/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryEndPortalFrame;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryEnergy;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryFluid;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryHackable;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryInventory;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryMisc;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryMobSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public enum BlockTrackHandler {
    INSTANCE;

    private final Map<ResourceLocation, Supplier<? extends IBlockTrackEntry>> pendingTrackers = new ConcurrentHashMap<ResourceLocation, Supplier<? extends IBlockTrackEntry>>();
    private List<IBlockTrackEntry> trackers;

    public static BlockTrackHandler getInstance() {
        return INSTANCE;
    }

    public void registerDefaultEntries() {
        this.register(BlockTrackEntryHackable.ID, BlockTrackEntryHackable::new);
        this.register(BlockTrackEntryInventory.ID, BlockTrackEntryInventory::new);
        this.register(BlockTrackEntryFluid.ID, BlockTrackEntryFluid::new);
        this.register(BlockTrackEntryEndPortalFrame.ID, BlockTrackEntryEndPortalFrame::new);
        this.register(BlockTrackEntryMobSpawner.ID, BlockTrackEntryMobSpawner::new);
        this.register(BlockTrackEntryMisc.ID, BlockTrackEntryMisc::new);
        this.register(BlockTrackEntryEnergy.ID, BlockTrackEntryEnergy::new);
    }

    public void register(ResourceLocation id, @Nonnull Supplier<? extends IBlockTrackEntry> entry) {
        if (this.trackers != null) {
            throw new IllegalStateException("entity tracker registry is frozen!");
        }
        this.pendingTrackers.put(id, entry);
    }

    public void freeze() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Supplier<? extends IBlockTrackEntry> sup : this.pendingTrackers.values()) {
            builder.add((Object)sup.get());
        }
        this.trackers = builder.build();
    }

    public List<IBlockTrackEntry> getEntriesForCoordinate(BlockGetter blockAccess, BlockPos pos, BlockEntity te) {
        BlockState state = blockAccess.m_8055_(pos);
        ArrayList<IBlockTrackEntry> trackers = new ArrayList<IBlockTrackEntry>();
        for (IBlockTrackEntry tracker : this.trackers) {
            WidgetKeybindCheckBox checkBox = WidgetKeybindCheckBox.get(tracker.getEntryID());
            if (checkBox == null || !checkBox.isChecked() || !tracker.shouldTrackWithThisEntry(blockAccess, pos, state, te)) continue;
            trackers.add(tracker);
        }
        return trackers;
    }

    public Collection<ResourceLocation> getIDs() {
        return ImmutableList.copyOf(this.pendingTrackers.keySet());
    }

    public List<IBlockTrackEntry> getEntries() {
        return this.trackers;
    }
}

